package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class InputDestinationVpc(
    availabilityZone: Option[__string] = None,
    networkInterfaceId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputDestinationVpc = {
    import InputDestinationVpc.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputDestinationVpc
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputDestinationVpc.ReadOnly =
    zio.aws.medialive.model.InputDestinationVpc.wrap(buildAwsValue())
}
object InputDestinationVpc {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputDestinationVpc
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputDestinationVpc =
      zio.aws.medialive.model.InputDestinationVpc(
        availabilityZone.map(value => value),
        networkInterfaceId.map(value => value)
      )
    def availabilityZone: Option[__string]
    def networkInterfaceId: Option[__string]
    def getAvailabilityZone: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getNetworkInterfaceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputDestinationVpc
  ) extends zio.aws.medialive.model.InputDestinationVpc.ReadOnly {
    override val availabilityZone: Option[__string] =
      scala.Option(impl.availabilityZone()).map(value => value: __string)
    override val networkInterfaceId: Option[__string] =
      scala.Option(impl.networkInterfaceId()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputDestinationVpc
  ): zio.aws.medialive.model.InputDestinationVpc.ReadOnly = new Wrapper(impl)
}
