package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputDeviceActiveInput {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.InputDeviceActiveInput
}
object InputDeviceActiveInput {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputDeviceActiveInput
  ): zio.aws.medialive.model.InputDeviceActiveInput = value match {
    case software.amazon.awssdk.services.medialive.model.InputDeviceActiveInput.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceActiveInput.HDMI =>
      val r = HDMI
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceActiveInput.SDI =>
      val r = SDI
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputDeviceActiveInput {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceActiveInput =
      software.amazon.awssdk.services.medialive.model.InputDeviceActiveInput.UNKNOWN_TO_SDK_VERSION
  }
  case object HDMI extends zio.aws.medialive.model.InputDeviceActiveInput {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceActiveInput =
      software.amazon.awssdk.services.medialive.model.InputDeviceActiveInput.HDMI
  }
  case object SDI extends zio.aws.medialive.model.InputDeviceActiveInput {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceActiveInput =
      software.amazon.awssdk.services.medialive.model.InputDeviceActiveInput.SDI
  }
}
