package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integer
import scala.jdk.CollectionConverters._
final case class InputDeviceConfigurableSettings(
    configuredInput: Option[
      zio.aws.medialive.model.InputDeviceConfiguredInput
    ] = None,
    maxBitrate: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputDeviceConfigurableSettings = {
    import InputDeviceConfigurableSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputDeviceConfigurableSettings
      .builder()
      .optionallyWith(configuredInput.map(value => value.unwrap))(
        _.configuredInput
      )
      .optionallyWith(maxBitrate.map(value => value: Integer))(_.maxBitrate)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.InputDeviceConfigurableSettings.ReadOnly =
    zio.aws.medialive.model.InputDeviceConfigurableSettings
      .wrap(buildAwsValue())
}
object InputDeviceConfigurableSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputDeviceConfigurableSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputDeviceConfigurableSettings =
      zio.aws.medialive.model.InputDeviceConfigurableSettings(
        configuredInput.map(value => value),
        maxBitrate.map(value => value)
      )
    def configuredInput
        : Option[zio.aws.medialive.model.InputDeviceConfiguredInput]
    def maxBitrate: Option[__integer]
    def getConfiguredInput: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputDeviceConfiguredInput
    ] = AwsError.unwrapOptionField("configuredInput", configuredInput)
    def getMaxBitrate: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxBitrate", maxBitrate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputDeviceConfigurableSettings
  ) extends zio.aws.medialive.model.InputDeviceConfigurableSettings.ReadOnly {
    override val configuredInput
        : Option[zio.aws.medialive.model.InputDeviceConfiguredInput] = scala
      .Option(impl.configuredInput())
      .map(value =>
        zio.aws.medialive.model.InputDeviceConfiguredInput.wrap(value)
      )
    override val maxBitrate: Option[__integer] =
      scala.Option(impl.maxBitrate()).map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputDeviceConfigurableSettings
  ): zio.aws.medialive.model.InputDeviceConfigurableSettings.ReadOnly =
    new Wrapper(impl)
}
