package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputDeviceConfiguredInput {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput
}
object InputDeviceConfiguredInput {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput
  ): zio.aws.medialive.model.InputDeviceConfiguredInput = value match {
    case software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput.HDMI =>
      val r = HDMI
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput.SDI =>
      val r = SDI
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputDeviceConfiguredInput {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput =
      software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO extends zio.aws.medialive.model.InputDeviceConfiguredInput {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput =
      software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput.AUTO
  }
  case object HDMI extends zio.aws.medialive.model.InputDeviceConfiguredInput {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput =
      software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput.HDMI
  }
  case object SDI extends zio.aws.medialive.model.InputDeviceConfiguredInput {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput =
      software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput.SDI
  }
}
