package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputDeviceConnectionState {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputDeviceConnectionState
}
object InputDeviceConnectionState {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputDeviceConnectionState
  ): zio.aws.medialive.model.InputDeviceConnectionState = value match {
    case software.amazon.awssdk.services.medialive.model.InputDeviceConnectionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceConnectionState.DISCONNECTED =>
      val r = DISCONNECTED
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceConnectionState.CONNECTED =>
      val r = CONNECTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputDeviceConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceConnectionState =
      software.amazon.awssdk.services.medialive.model.InputDeviceConnectionState.UNKNOWN_TO_SDK_VERSION
  }
  case object DISCONNECTED
      extends zio.aws.medialive.model.InputDeviceConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceConnectionState =
      software.amazon.awssdk.services.medialive.model.InputDeviceConnectionState.DISCONNECTED
  }
  case object CONNECTED
      extends zio.aws.medialive.model.InputDeviceConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceConnectionState =
      software.amazon.awssdk.services.medialive.model.InputDeviceConnectionState.CONNECTED
  }
}
