package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__integer, __double}
import scala.jdk.CollectionConverters._
final case class InputDeviceHdSettings(
    activeInput: Option[zio.aws.medialive.model.InputDeviceActiveInput] = None,
    configuredInput: Option[
      zio.aws.medialive.model.InputDeviceConfiguredInput
    ] = None,
    deviceState: Option[zio.aws.medialive.model.InputDeviceState] = None,
    framerate: Option[__double] = None,
    height: Option[__integer] = None,
    maxBitrate: Option[__integer] = None,
    scanType: Option[zio.aws.medialive.model.InputDeviceScanType] = None,
    width: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputDeviceHdSettings = {
    import InputDeviceHdSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputDeviceHdSettings
      .builder()
      .optionallyWith(activeInput.map(value => value.unwrap))(_.activeInput)
      .optionallyWith(configuredInput.map(value => value.unwrap))(
        _.configuredInput
      )
      .optionallyWith(deviceState.map(value => value.unwrap))(_.deviceState)
      .optionallyWith(framerate.map(value => value: java.lang.Double))(
        _.framerate
      )
      .optionallyWith(height.map(value => value: Integer))(_.height)
      .optionallyWith(maxBitrate.map(value => value: Integer))(_.maxBitrate)
      .optionallyWith(scanType.map(value => value.unwrap))(_.scanType)
      .optionallyWith(width.map(value => value: Integer))(_.width)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputDeviceHdSettings.ReadOnly =
    zio.aws.medialive.model.InputDeviceHdSettings.wrap(buildAwsValue())
}
object InputDeviceHdSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputDeviceHdSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputDeviceHdSettings =
      zio.aws.medialive.model.InputDeviceHdSettings(
        activeInput.map(value => value),
        configuredInput.map(value => value),
        deviceState.map(value => value),
        framerate.map(value => value),
        height.map(value => value),
        maxBitrate.map(value => value),
        scanType.map(value => value),
        width.map(value => value)
      )
    def activeInput: Option[zio.aws.medialive.model.InputDeviceActiveInput]
    def configuredInput
        : Option[zio.aws.medialive.model.InputDeviceConfiguredInput]
    def deviceState: Option[zio.aws.medialive.model.InputDeviceState]
    def framerate: Option[__double]
    def height: Option[__integer]
    def maxBitrate: Option[__integer]
    def scanType: Option[zio.aws.medialive.model.InputDeviceScanType]
    def width: Option[__integer]
    def getActiveInput
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputDeviceActiveInput] =
      AwsError.unwrapOptionField("activeInput", activeInput)
    def getConfiguredInput: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputDeviceConfiguredInput
    ] = AwsError.unwrapOptionField("configuredInput", configuredInput)
    def getDeviceState
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputDeviceState] =
      AwsError.unwrapOptionField("deviceState", deviceState)
    def getFramerate: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("framerate", framerate)
    def getHeight: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("height", height)
    def getMaxBitrate: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxBitrate", maxBitrate)
    def getScanType
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputDeviceScanType] =
      AwsError.unwrapOptionField("scanType", scanType)
    def getWidth: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("width", width)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputDeviceHdSettings
  ) extends zio.aws.medialive.model.InputDeviceHdSettings.ReadOnly {
    override val activeInput
        : Option[zio.aws.medialive.model.InputDeviceActiveInput] = scala
      .Option(impl.activeInput())
      .map(value => zio.aws.medialive.model.InputDeviceActiveInput.wrap(value))
    override val configuredInput
        : Option[zio.aws.medialive.model.InputDeviceConfiguredInput] = scala
      .Option(impl.configuredInput())
      .map(value =>
        zio.aws.medialive.model.InputDeviceConfiguredInput.wrap(value)
      )
    override val deviceState: Option[zio.aws.medialive.model.InputDeviceState] =
      scala
        .Option(impl.deviceState())
        .map(value => zio.aws.medialive.model.InputDeviceState.wrap(value))
    override val framerate: Option[__double] =
      scala.Option(impl.framerate()).map(value => value: __double)
    override val height: Option[__integer] =
      scala.Option(impl.height()).map(value => value: __integer)
    override val maxBitrate: Option[__integer] =
      scala.Option(impl.maxBitrate()).map(value => value: __integer)
    override val scanType: Option[zio.aws.medialive.model.InputDeviceScanType] =
      scala
        .Option(impl.scanType())
        .map(value => zio.aws.medialive.model.InputDeviceScanType.wrap(value))
    override val width: Option[__integer] =
      scala.Option(impl.width()).map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputDeviceHdSettings
  ): zio.aws.medialive.model.InputDeviceHdSettings.ReadOnly = new Wrapper(impl)
}
