package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputDeviceIpScheme {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.InputDeviceIpScheme
}
object InputDeviceIpScheme {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputDeviceIpScheme
  ): zio.aws.medialive.model.InputDeviceIpScheme = value match {
    case software.amazon.awssdk.services.medialive.model.InputDeviceIpScheme.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceIpScheme.STATIC =>
      val r = STATIC
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceIpScheme.DHCP =>
      val r = DHCP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputDeviceIpScheme {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceIpScheme =
      software.amazon.awssdk.services.medialive.model.InputDeviceIpScheme.UNKNOWN_TO_SDK_VERSION
  }
  case object STATIC extends zio.aws.medialive.model.InputDeviceIpScheme {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceIpScheme =
      software.amazon.awssdk.services.medialive.model.InputDeviceIpScheme.STATIC
  }
  case object DHCP extends zio.aws.medialive.model.InputDeviceIpScheme {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceIpScheme =
      software.amazon.awssdk.services.medialive.model.InputDeviceIpScheme.DHCP
  }
}
