package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class InputDeviceNetworkSettings(
    dnsAddresses: Option[Iterable[__string]] = None,
    gateway: Option[__string] = None,
    ipAddress: Option[__string] = None,
    ipScheme: Option[zio.aws.medialive.model.InputDeviceIpScheme] = None,
    subnetMask: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputDeviceNetworkSettings = {
    import InputDeviceNetworkSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputDeviceNetworkSettings
      .builder()
      .optionallyWith(
        dnsAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dnsAddresses)
      .optionallyWith(gateway.map(value => value: java.lang.String))(_.gateway)
      .optionallyWith(ipAddress.map(value => value: java.lang.String))(
        _.ipAddress
      )
      .optionallyWith(ipScheme.map(value => value.unwrap))(_.ipScheme)
      .optionallyWith(subnetMask.map(value => value: java.lang.String))(
        _.subnetMask
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputDeviceNetworkSettings.ReadOnly =
    zio.aws.medialive.model.InputDeviceNetworkSettings.wrap(buildAwsValue())
}
object InputDeviceNetworkSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputDeviceNetworkSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputDeviceNetworkSettings =
      zio.aws.medialive.model.InputDeviceNetworkSettings(
        dnsAddresses.map(value => value),
        gateway.map(value => value),
        ipAddress.map(value => value),
        ipScheme.map(value => value),
        subnetMask.map(value => value)
      )
    def dnsAddresses: Option[List[__string]]
    def gateway: Option[__string]
    def ipAddress: Option[__string]
    def ipScheme: Option[zio.aws.medialive.model.InputDeviceIpScheme]
    def subnetMask: Option[__string]
    def getDnsAddresses: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("dnsAddresses", dnsAddresses)
    def getGateway: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("gateway", gateway)
    def getIpAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getIpScheme
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputDeviceIpScheme] =
      AwsError.unwrapOptionField("ipScheme", ipScheme)
    def getSubnetMask: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("subnetMask", subnetMask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputDeviceNetworkSettings
  ) extends zio.aws.medialive.model.InputDeviceNetworkSettings.ReadOnly {
    override val dnsAddresses: Option[List[__string]] = scala
      .Option(impl.dnsAddresses())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val gateway: Option[__string] =
      scala.Option(impl.gateway()).map(value => value: __string)
    override val ipAddress: Option[__string] =
      scala.Option(impl.ipAddress()).map(value => value: __string)
    override val ipScheme: Option[zio.aws.medialive.model.InputDeviceIpScheme] =
      scala
        .Option(impl.ipScheme())
        .map(value => zio.aws.medialive.model.InputDeviceIpScheme.wrap(value))
    override val subnetMask: Option[__string] =
      scala.Option(impl.subnetMask()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputDeviceNetworkSettings
  ): zio.aws.medialive.model.InputDeviceNetworkSettings.ReadOnly = new Wrapper(
    impl
  )
}
