package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputDeviceScanType {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.InputDeviceScanType
}
object InputDeviceScanType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputDeviceScanType
  ): zio.aws.medialive.model.InputDeviceScanType = value match {
    case software.amazon.awssdk.services.medialive.model.InputDeviceScanType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceScanType.INTERLACED =>
      val r = INTERLACED
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceScanType.PROGRESSIVE =>
      val r = PROGRESSIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputDeviceScanType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceScanType =
      software.amazon.awssdk.services.medialive.model.InputDeviceScanType.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERLACED extends zio.aws.medialive.model.InputDeviceScanType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceScanType =
      software.amazon.awssdk.services.medialive.model.InputDeviceScanType.INTERLACED
  }
  case object PROGRESSIVE extends zio.aws.medialive.model.InputDeviceScanType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceScanType =
      software.amazon.awssdk.services.medialive.model.InputDeviceScanType.PROGRESSIVE
  }
}
