package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class InputDeviceSettings(id: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputDeviceSettings = {
    import InputDeviceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputDeviceSettings
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputDeviceSettings.ReadOnly =
    zio.aws.medialive.model.InputDeviceSettings.wrap(buildAwsValue())
}
object InputDeviceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputDeviceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputDeviceSettings =
      zio.aws.medialive.model.InputDeviceSettings(id.map(value => value))
    def id: Option[__string]
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputDeviceSettings
  ) extends zio.aws.medialive.model.InputDeviceSettings.ReadOnly {
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputDeviceSettings
  ): zio.aws.medialive.model.InputDeviceSettings.ReadOnly = new Wrapper(impl)
}
