package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputDeviceState {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputDeviceState
}
object InputDeviceState {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputDeviceState
  ): zio.aws.medialive.model.InputDeviceState = value match {
    case software.amazon.awssdk.services.medialive.model.InputDeviceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceState.IDLE =>
      val r = IDLE
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceState.STREAMING =>
      val r = STREAMING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputDeviceState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceState =
      software.amazon.awssdk.services.medialive.model.InputDeviceState.UNKNOWN_TO_SDK_VERSION
  }
  case object IDLE extends zio.aws.medialive.model.InputDeviceState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceState =
      software.amazon.awssdk.services.medialive.model.InputDeviceState.IDLE
  }
  case object STREAMING extends zio.aws.medialive.model.InputDeviceState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceState =
      software.amazon.awssdk.services.medialive.model.InputDeviceState.STREAMING
  }
}
