package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputDeviceTransferType {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.InputDeviceTransferType
}
object InputDeviceTransferType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputDeviceTransferType
  ): zio.aws.medialive.model.InputDeviceTransferType = value match {
    case software.amazon.awssdk.services.medialive.model.InputDeviceTransferType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceTransferType.OUTGOING =>
      val r = OUTGOING
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceTransferType.INCOMING =>
      val r = INCOMING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputDeviceTransferType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceTransferType =
      software.amazon.awssdk.services.medialive.model.InputDeviceTransferType.UNKNOWN_TO_SDK_VERSION
  }
  case object OUTGOING extends zio.aws.medialive.model.InputDeviceTransferType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceTransferType =
      software.amazon.awssdk.services.medialive.model.InputDeviceTransferType.OUTGOING
  }
  case object INCOMING extends zio.aws.medialive.model.InputDeviceTransferType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceTransferType =
      software.amazon.awssdk.services.medialive.model.InputDeviceTransferType.INCOMING
  }
}
