package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputDeviceType {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputDeviceType
}
object InputDeviceType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputDeviceType
  ): zio.aws.medialive.model.InputDeviceType = value match {
    case software.amazon.awssdk.services.medialive.model.InputDeviceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputDeviceType.HD =>
      val r = HD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceType =
      software.amazon.awssdk.services.medialive.model.InputDeviceType.UNKNOWN_TO_SDK_VERSION
  }
  case object HD extends zio.aws.medialive.model.InputDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputDeviceType =
      software.amazon.awssdk.services.medialive.model.InputDeviceType.HD
  }
}
