package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputFilter {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputFilter
}
object InputFilter {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputFilter
  ): zio.aws.medialive.model.InputFilter = value match {
    case software.amazon.awssdk.services.medialive.model.InputFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputFilter.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.medialive.model.InputFilter.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.InputFilter.FORCED =>
      val r = FORCED
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.InputFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputFilter =
      software.amazon.awssdk.services.medialive.model.InputFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO extends zio.aws.medialive.model.InputFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputFilter =
      software.amazon.awssdk.services.medialive.model.InputFilter.AUTO
  }
  case object DISABLED extends zio.aws.medialive.model.InputFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputFilter =
      software.amazon.awssdk.services.medialive.model.InputFilter.DISABLED
  }
  case object FORCED extends zio.aws.medialive.model.InputFilter {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputFilter =
      software.amazon.awssdk.services.medialive.model.InputFilter.FORCED
  }
}
