package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class InputLocation(
    passwordParam: Option[__string] = None,
    uri: __string,
    username: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputLocation = {
    import InputLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputLocation
      .builder()
      .optionallyWith(passwordParam.map(value => value: java.lang.String))(
        _.passwordParam
      )
      .uri(uri: java.lang.String)
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputLocation.ReadOnly =
    zio.aws.medialive.model.InputLocation.wrap(buildAwsValue())
}
object InputLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputLocation =
      zio.aws.medialive.model.InputLocation(
        passwordParam.map(value => value),
        uri,
        username.map(value => value)
      )
    def passwordParam: Option[__string]
    def uri: __string
    def username: Option[__string]
    def getPasswordParam: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("passwordParam", passwordParam)
    def getUri: ZIO[Any, Nothing, __string] = ZIO.succeed(uri)
    def getUsername: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputLocation
  ) extends zio.aws.medialive.model.InputLocation.ReadOnly {
    override val passwordParam: Option[__string] =
      scala.Option(impl.passwordParam()).map(value => value: __string)
    override val uri: __string = impl.uri(): __string
    override val username: Option[__string] =
      scala.Option(impl.username()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputLocation
  ): zio.aws.medialive.model.InputLocation.ReadOnly = new Wrapper(impl)
}
