package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __stringMin6Max6,
  __integerMin0Max1000000
}
import scala.jdk.CollectionConverters._
final case class InputLossBehavior(
    blackFrameMsec: Option[__integerMin0Max1000000] = None,
    inputLossImageColor: Option[__stringMin6Max6] = None,
    inputLossImageSlate: Option[zio.aws.medialive.model.InputLocation] = None,
    inputLossImageType: Option[zio.aws.medialive.model.InputLossImageType] =
      None,
    repeatFrameMsec: Option[__integerMin0Max1000000] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputLossBehavior = {
    import InputLossBehavior.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputLossBehavior
      .builder()
      .optionallyWith(blackFrameMsec.map(value => value: Integer))(
        _.blackFrameMsec
      )
      .optionallyWith(
        inputLossImageColor.map(value => value: java.lang.String)
      )(_.inputLossImageColor)
      .optionallyWith(inputLossImageSlate.map(value => value.buildAwsValue()))(
        _.inputLossImageSlate
      )
      .optionallyWith(inputLossImageType.map(value => value.unwrap))(
        _.inputLossImageType
      )
      .optionallyWith(repeatFrameMsec.map(value => value: Integer))(
        _.repeatFrameMsec
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputLossBehavior.ReadOnly =
    zio.aws.medialive.model.InputLossBehavior.wrap(buildAwsValue())
}
object InputLossBehavior {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputLossBehavior
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputLossBehavior =
      zio.aws.medialive.model.InputLossBehavior(
        blackFrameMsec.map(value => value),
        inputLossImageColor.map(value => value),
        inputLossImageSlate.map(value => value.asEditable),
        inputLossImageType.map(value => value),
        repeatFrameMsec.map(value => value)
      )
    def blackFrameMsec: Option[__integerMin0Max1000000]
    def inputLossImageColor: Option[__stringMin6Max6]
    def inputLossImageSlate
        : Option[zio.aws.medialive.model.InputLocation.ReadOnly]
    def inputLossImageType: Option[zio.aws.medialive.model.InputLossImageType]
    def repeatFrameMsec: Option[__integerMin0Max1000000]
    def getBlackFrameMsec: ZIO[Any, AwsError, __integerMin0Max1000000] =
      AwsError.unwrapOptionField("blackFrameMsec", blackFrameMsec)
    def getInputLossImageColor: ZIO[Any, AwsError, __stringMin6Max6] =
      AwsError.unwrapOptionField("inputLossImageColor", inputLossImageColor)
    def getInputLossImageSlate
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputLocation.ReadOnly] =
      AwsError.unwrapOptionField("inputLossImageSlate", inputLossImageSlate)
    def getInputLossImageType
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputLossImageType] =
      AwsError.unwrapOptionField("inputLossImageType", inputLossImageType)
    def getRepeatFrameMsec: ZIO[Any, AwsError, __integerMin0Max1000000] =
      AwsError.unwrapOptionField("repeatFrameMsec", repeatFrameMsec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputLossBehavior
  ) extends zio.aws.medialive.model.InputLossBehavior.ReadOnly {
    override val blackFrameMsec: Option[__integerMin0Max1000000] = scala
      .Option(impl.blackFrameMsec())
      .map(value => value: __integerMin0Max1000000)
    override val inputLossImageColor: Option[__stringMin6Max6] = scala
      .Option(impl.inputLossImageColor())
      .map(value => value: __stringMin6Max6)
    override val inputLossImageSlate
        : Option[zio.aws.medialive.model.InputLocation.ReadOnly] = scala
      .Option(impl.inputLossImageSlate())
      .map(value => zio.aws.medialive.model.InputLocation.wrap(value))
    override val inputLossImageType
        : Option[zio.aws.medialive.model.InputLossImageType] = scala
      .Option(impl.inputLossImageType())
      .map(value => zio.aws.medialive.model.InputLossImageType.wrap(value))
    override val repeatFrameMsec: Option[__integerMin0Max1000000] = scala
      .Option(impl.repeatFrameMsec())
      .map(value => value: __integerMin0Max1000000)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputLossBehavior
  ): zio.aws.medialive.model.InputLossBehavior.ReadOnly = new Wrapper(impl)
}
