package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin100
import scala.jdk.CollectionConverters._
final case class InputLossFailoverSettings(
    inputLossThresholdMsec: Option[__integerMin100] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputLossFailoverSettings = {
    import InputLossFailoverSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputLossFailoverSettings
      .builder()
      .optionallyWith(inputLossThresholdMsec.map(value => value: Integer))(
        _.inputLossThresholdMsec
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputLossFailoverSettings.ReadOnly =
    zio.aws.medialive.model.InputLossFailoverSettings.wrap(buildAwsValue())
}
object InputLossFailoverSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputLossFailoverSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputLossFailoverSettings =
      zio.aws.medialive.model
        .InputLossFailoverSettings(inputLossThresholdMsec.map(value => value))
    def inputLossThresholdMsec: Option[__integerMin100]
    def getInputLossThresholdMsec: ZIO[Any, AwsError, __integerMin100] =
      AwsError.unwrapOptionField(
        "inputLossThresholdMsec",
        inputLossThresholdMsec
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputLossFailoverSettings
  ) extends zio.aws.medialive.model.InputLossFailoverSettings.ReadOnly {
    override val inputLossThresholdMsec: Option[__integerMin100] = scala
      .Option(impl.inputLossThresholdMsec())
      .map(value => value: __integerMin100)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputLossFailoverSettings
  ): zio.aws.medialive.model.InputLossFailoverSettings.ReadOnly = new Wrapper(
    impl
  )
}
