package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputLossImageType {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputLossImageType
}
object InputLossImageType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputLossImageType
  ): zio.aws.medialive.model.InputLossImageType = value match {
    case software.amazon.awssdk.services.medialive.model.InputLossImageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputLossImageType.COLOR =>
      val r = COLOR
      r
    case software.amazon.awssdk.services.medialive.model.InputLossImageType.SLATE =>
      val r = SLATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputLossImageType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputLossImageType =
      software.amazon.awssdk.services.medialive.model.InputLossImageType.UNKNOWN_TO_SDK_VERSION
  }
  case object COLOR extends zio.aws.medialive.model.InputLossImageType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputLossImageType =
      software.amazon.awssdk.services.medialive.model.InputLossImageType.COLOR
  }
  case object SLATE extends zio.aws.medialive.model.InputLossImageType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputLossImageType =
      software.amazon.awssdk.services.medialive.model.InputLossImageType.SLATE
  }
}
