package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputMaximumBitrate {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.InputMaximumBitrate
}
object InputMaximumBitrate {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputMaximumBitrate
  ): zio.aws.medialive.model.InputMaximumBitrate = value match {
    case software.amazon.awssdk.services.medialive.model.InputMaximumBitrate.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputMaximumBitrate.MAX_10_MBPS =>
      val r = MAX_10_MBPS
      r
    case software.amazon.awssdk.services.medialive.model.InputMaximumBitrate.MAX_20_MBPS =>
      val r = MAX_20_MBPS
      r
    case software.amazon.awssdk.services.medialive.model.InputMaximumBitrate.MAX_50_MBPS =>
      val r = MAX_50_MBPS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputMaximumBitrate {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputMaximumBitrate =
      software.amazon.awssdk.services.medialive.model.InputMaximumBitrate.UNKNOWN_TO_SDK_VERSION
  }
  case object MAX_10_MBPS extends zio.aws.medialive.model.InputMaximumBitrate {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputMaximumBitrate =
      software.amazon.awssdk.services.medialive.model.InputMaximumBitrate.MAX_10_MBPS
  }
  case object MAX_20_MBPS extends zio.aws.medialive.model.InputMaximumBitrate {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputMaximumBitrate =
      software.amazon.awssdk.services.medialive.model.InputMaximumBitrate.MAX_20_MBPS
  }
  case object MAX_50_MBPS extends zio.aws.medialive.model.InputMaximumBitrate {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputMaximumBitrate =
      software.amazon.awssdk.services.medialive.model.InputMaximumBitrate.MAX_50_MBPS
  }
}
