package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputPreference {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputPreference
}
object InputPreference {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputPreference
  ): zio.aws.medialive.model.InputPreference = value match {
    case software.amazon.awssdk.services.medialive.model.InputPreference.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputPreference.EQUAL_INPUT_PREFERENCE =>
      val r = EQUAL_INPUT_PREFERENCE
      r
    case software.amazon.awssdk.services.medialive.model.InputPreference.PRIMARY_INPUT_PREFERRED =>
      val r = PRIMARY_INPUT_PREFERRED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputPreference {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputPreference =
      software.amazon.awssdk.services.medialive.model.InputPreference.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUAL_INPUT_PREFERENCE
      extends zio.aws.medialive.model.InputPreference {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputPreference =
      software.amazon.awssdk.services.medialive.model.InputPreference.EQUAL_INPUT_PREFERENCE
  }
  case object PRIMARY_INPUT_PREFERRED
      extends zio.aws.medialive.model.InputPreference {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputPreference =
      software.amazon.awssdk.services.medialive.model.InputPreference.PRIMARY_INPUT_PREFERRED
  }
}
