package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class InputPrepareScheduleActionSettings(
    inputAttachmentNameReference: Option[__string] = None,
    inputClippingSettings: Option[
      zio.aws.medialive.model.InputClippingSettings
    ] = None,
    urlPath: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputPrepareScheduleActionSettings = {
    import InputPrepareScheduleActionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputPrepareScheduleActionSettings
      .builder()
      .optionallyWith(
        inputAttachmentNameReference.map(value => value: java.lang.String)
      )(_.inputAttachmentNameReference)
      .optionallyWith(
        inputClippingSettings.map(value => value.buildAwsValue())
      )(_.inputClippingSettings)
      .optionallyWith(
        urlPath.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.urlPath)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.InputPrepareScheduleActionSettings.ReadOnly =
    zio.aws.medialive.model.InputPrepareScheduleActionSettings
      .wrap(buildAwsValue())
}
object InputPrepareScheduleActionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputPrepareScheduleActionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputPrepareScheduleActionSettings =
      zio.aws.medialive.model.InputPrepareScheduleActionSettings(
        inputAttachmentNameReference.map(value => value),
        inputClippingSettings.map(value => value.asEditable),
        urlPath.map(value => value)
      )
    def inputAttachmentNameReference: Option[__string]
    def inputClippingSettings
        : Option[zio.aws.medialive.model.InputClippingSettings.ReadOnly]
    def urlPath: Option[List[__string]]
    def getInputAttachmentNameReference: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "inputAttachmentNameReference",
        inputAttachmentNameReference
      )
    def getInputClippingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputClippingSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("inputClippingSettings", inputClippingSettings)
    def getUrlPath: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("urlPath", urlPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputPrepareScheduleActionSettings
  ) extends zio.aws.medialive.model.InputPrepareScheduleActionSettings.ReadOnly {
    override val inputAttachmentNameReference: Option[__string] = scala
      .Option(impl.inputAttachmentNameReference())
      .map(value => value: __string)
    override val inputClippingSettings
        : Option[zio.aws.medialive.model.InputClippingSettings.ReadOnly] = scala
      .Option(impl.inputClippingSettings())
      .map(value => zio.aws.medialive.model.InputClippingSettings.wrap(value))
    override val urlPath: Option[List[__string]] = scala
      .Option(impl.urlPath())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputPrepareScheduleActionSettings
  ): zio.aws.medialive.model.InputPrepareScheduleActionSettings.ReadOnly =
    new Wrapper(impl)
}
