package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputResolution {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputResolution
}
object InputResolution {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputResolution
  ): zio.aws.medialive.model.InputResolution = value match {
    case software.amazon.awssdk.services.medialive.model.InputResolution.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputResolution.SD =>
      val r = SD
      r
    case software.amazon.awssdk.services.medialive.model.InputResolution.HD =>
      val r = HD
      r
    case software.amazon.awssdk.services.medialive.model.InputResolution.UHD =>
      val r = UHD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputResolution =
      software.amazon.awssdk.services.medialive.model.InputResolution.UNKNOWN_TO_SDK_VERSION
  }
  case object SD extends zio.aws.medialive.model.InputResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputResolution =
      software.amazon.awssdk.services.medialive.model.InputResolution.SD
  }
  case object HD extends zio.aws.medialive.model.InputResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputResolution =
      software.amazon.awssdk.services.medialive.model.InputResolution.HD
  }
  case object UHD extends zio.aws.medialive.model.InputResolution {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputResolution =
      software.amazon.awssdk.services.medialive.model.InputResolution.UHD
  }
}
