package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputSecurityGroupState {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.InputSecurityGroupState
}
object InputSecurityGroupState {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputSecurityGroupState
  ): zio.aws.medialive.model.InputSecurityGroupState = value match {
    case software.amazon.awssdk.services.medialive.model.InputSecurityGroupState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputSecurityGroupState.IDLE =>
      val r = IDLE
      r
    case software.amazon.awssdk.services.medialive.model.InputSecurityGroupState.IN_USE =>
      val r = IN_USE
      r
    case software.amazon.awssdk.services.medialive.model.InputSecurityGroupState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.medialive.model.InputSecurityGroupState.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputSecurityGroupState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputSecurityGroupState =
      software.amazon.awssdk.services.medialive.model.InputSecurityGroupState.UNKNOWN_TO_SDK_VERSION
  }
  case object IDLE extends zio.aws.medialive.model.InputSecurityGroupState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputSecurityGroupState =
      software.amazon.awssdk.services.medialive.model.InputSecurityGroupState.IDLE
  }
  case object IN_USE extends zio.aws.medialive.model.InputSecurityGroupState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputSecurityGroupState =
      software.amazon.awssdk.services.medialive.model.InputSecurityGroupState.IN_USE
  }
  case object UPDATING extends zio.aws.medialive.model.InputSecurityGroupState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputSecurityGroupState =
      software.amazon.awssdk.services.medialive.model.InputSecurityGroupState.UPDATING
  }
  case object DELETED extends zio.aws.medialive.model.InputSecurityGroupState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputSecurityGroupState =
      software.amazon.awssdk.services.medialive.model.InputSecurityGroupState.DELETED
  }
}
