package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin32Max8191,
  __integerMin1Max5
}
import scala.jdk.CollectionConverters._
final case class InputSettings(
    audioSelectors: Option[Iterable[zio.aws.medialive.model.AudioSelector]] =
      None,
    captionSelectors: Option[
      Iterable[zio.aws.medialive.model.CaptionSelector]
    ] = None,
    deblockFilter: Option[zio.aws.medialive.model.InputDeblockFilter] = None,
    denoiseFilter: Option[zio.aws.medialive.model.InputDenoiseFilter] = None,
    filterStrength: Option[__integerMin1Max5] = None,
    inputFilter: Option[zio.aws.medialive.model.InputFilter] = None,
    networkInputSettings: Option[zio.aws.medialive.model.NetworkInputSettings] =
      None,
    scte35Pid: Option[__integerMin32Max8191] = None,
    smpte2038DataPreference: Option[
      zio.aws.medialive.model.Smpte2038DataPreference
    ] = None,
    sourceEndBehavior: Option[zio.aws.medialive.model.InputSourceEndBehavior] =
      None,
    videoSelector: Option[zio.aws.medialive.model.VideoSelector] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputSettings = {
    import InputSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputSettings
      .builder()
      .optionallyWith(
        audioSelectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.audioSelectors)
      .optionallyWith(
        captionSelectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.captionSelectors)
      .optionallyWith(deblockFilter.map(value => value.unwrap))(_.deblockFilter)
      .optionallyWith(denoiseFilter.map(value => value.unwrap))(_.denoiseFilter)
      .optionallyWith(filterStrength.map(value => value: Integer))(
        _.filterStrength
      )
      .optionallyWith(inputFilter.map(value => value.unwrap))(_.inputFilter)
      .optionallyWith(networkInputSettings.map(value => value.buildAwsValue()))(
        _.networkInputSettings
      )
      .optionallyWith(scte35Pid.map(value => value: Integer))(_.scte35Pid)
      .optionallyWith(smpte2038DataPreference.map(value => value.unwrap))(
        _.smpte2038DataPreference
      )
      .optionallyWith(sourceEndBehavior.map(value => value.unwrap))(
        _.sourceEndBehavior
      )
      .optionallyWith(videoSelector.map(value => value.buildAwsValue()))(
        _.videoSelector
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputSettings.ReadOnly =
    zio.aws.medialive.model.InputSettings.wrap(buildAwsValue())
}
object InputSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputSettings =
      zio.aws.medialive.model.InputSettings(
        audioSelectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        captionSelectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deblockFilter.map(value => value),
        denoiseFilter.map(value => value),
        filterStrength.map(value => value),
        inputFilter.map(value => value),
        networkInputSettings.map(value => value.asEditable),
        scte35Pid.map(value => value),
        smpte2038DataPreference.map(value => value),
        sourceEndBehavior.map(value => value),
        videoSelector.map(value => value.asEditable)
      )
    def audioSelectors
        : Option[List[zio.aws.medialive.model.AudioSelector.ReadOnly]]
    def captionSelectors
        : Option[List[zio.aws.medialive.model.CaptionSelector.ReadOnly]]
    def deblockFilter: Option[zio.aws.medialive.model.InputDeblockFilter]
    def denoiseFilter: Option[zio.aws.medialive.model.InputDenoiseFilter]
    def filterStrength: Option[__integerMin1Max5]
    def inputFilter: Option[zio.aws.medialive.model.InputFilter]
    def networkInputSettings
        : Option[zio.aws.medialive.model.NetworkInputSettings.ReadOnly]
    def scte35Pid: Option[__integerMin32Max8191]
    def smpte2038DataPreference
        : Option[zio.aws.medialive.model.Smpte2038DataPreference]
    def sourceEndBehavior
        : Option[zio.aws.medialive.model.InputSourceEndBehavior]
    def videoSelector: Option[zio.aws.medialive.model.VideoSelector.ReadOnly]
    def getAudioSelectors: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.AudioSelector.ReadOnly
    ]] = AwsError.unwrapOptionField("audioSelectors", audioSelectors)
    def getCaptionSelectors: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.CaptionSelector.ReadOnly
    ]] = AwsError.unwrapOptionField("captionSelectors", captionSelectors)
    def getDeblockFilter
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputDeblockFilter] =
      AwsError.unwrapOptionField("deblockFilter", deblockFilter)
    def getDenoiseFilter
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputDenoiseFilter] =
      AwsError.unwrapOptionField("denoiseFilter", denoiseFilter)
    def getFilterStrength: ZIO[Any, AwsError, __integerMin1Max5] =
      AwsError.unwrapOptionField("filterStrength", filterStrength)
    def getInputFilter
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputFilter] =
      AwsError.unwrapOptionField("inputFilter", inputFilter)
    def getNetworkInputSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.NetworkInputSettings.ReadOnly
    ] = AwsError.unwrapOptionField("networkInputSettings", networkInputSettings)
    def getScte35Pid: ZIO[Any, AwsError, __integerMin32Max8191] =
      AwsError.unwrapOptionField("scte35Pid", scte35Pid)
    def getSmpte2038DataPreference
        : ZIO[Any, AwsError, zio.aws.medialive.model.Smpte2038DataPreference] =
      AwsError.unwrapOptionField(
        "smpte2038DataPreference",
        smpte2038DataPreference
      )
    def getSourceEndBehavior
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputSourceEndBehavior] =
      AwsError.unwrapOptionField("sourceEndBehavior", sourceEndBehavior)
    def getVideoSelector
        : ZIO[Any, AwsError, zio.aws.medialive.model.VideoSelector.ReadOnly] =
      AwsError.unwrapOptionField("videoSelector", videoSelector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputSettings
  ) extends zio.aws.medialive.model.InputSettings.ReadOnly {
    override val audioSelectors
        : Option[List[zio.aws.medialive.model.AudioSelector.ReadOnly]] = scala
      .Option(impl.audioSelectors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.AudioSelector.wrap(item)
        }.toList
      )
    override val captionSelectors
        : Option[List[zio.aws.medialive.model.CaptionSelector.ReadOnly]] = scala
      .Option(impl.captionSelectors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.CaptionSelector.wrap(item)
        }.toList
      )
    override val deblockFilter
        : Option[zio.aws.medialive.model.InputDeblockFilter] = scala
      .Option(impl.deblockFilter())
      .map(value => zio.aws.medialive.model.InputDeblockFilter.wrap(value))
    override val denoiseFilter
        : Option[zio.aws.medialive.model.InputDenoiseFilter] = scala
      .Option(impl.denoiseFilter())
      .map(value => zio.aws.medialive.model.InputDenoiseFilter.wrap(value))
    override val filterStrength: Option[__integerMin1Max5] =
      scala.Option(impl.filterStrength()).map(value => value: __integerMin1Max5)
    override val inputFilter: Option[zio.aws.medialive.model.InputFilter] =
      scala
        .Option(impl.inputFilter())
        .map(value => zio.aws.medialive.model.InputFilter.wrap(value))
    override val networkInputSettings
        : Option[zio.aws.medialive.model.NetworkInputSettings.ReadOnly] = scala
      .Option(impl.networkInputSettings())
      .map(value => zio.aws.medialive.model.NetworkInputSettings.wrap(value))
    override val scte35Pid: Option[__integerMin32Max8191] =
      scala.Option(impl.scte35Pid()).map(value => value: __integerMin32Max8191)
    override val smpte2038DataPreference
        : Option[zio.aws.medialive.model.Smpte2038DataPreference] = scala
      .Option(impl.smpte2038DataPreference())
      .map(value => zio.aws.medialive.model.Smpte2038DataPreference.wrap(value))
    override val sourceEndBehavior
        : Option[zio.aws.medialive.model.InputSourceEndBehavior] = scala
      .Option(impl.sourceEndBehavior())
      .map(value => zio.aws.medialive.model.InputSourceEndBehavior.wrap(value))
    override val videoSelector
        : Option[zio.aws.medialive.model.VideoSelector.ReadOnly] = scala
      .Option(impl.videoSelector())
      .map(value => zio.aws.medialive.model.VideoSelector.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputSettings
  ): zio.aws.medialive.model.InputSettings.ReadOnly = new Wrapper(impl)
}
