package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class InputSource(
    passwordParam: Option[__string] = None,
    url: Option[__string] = None,
    username: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputSource = {
    import InputSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputSource
      .builder()
      .optionallyWith(passwordParam.map(value => value: java.lang.String))(
        _.passwordParam
      )
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputSource.ReadOnly =
    zio.aws.medialive.model.InputSource.wrap(buildAwsValue())
}
object InputSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputSource =
      zio.aws.medialive.model.InputSource(
        passwordParam.map(value => value),
        url.map(value => value),
        username.map(value => value)
      )
    def passwordParam: Option[__string]
    def url: Option[__string]
    def username: Option[__string]
    def getPasswordParam: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("passwordParam", passwordParam)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
    def getUsername: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputSource
  ) extends zio.aws.medialive.model.InputSource.ReadOnly {
    override val passwordParam: Option[__string] =
      scala.Option(impl.passwordParam()).map(value => value: __string)
    override val url: Option[__string] =
      scala.Option(impl.url()).map(value => value: __string)
    override val username: Option[__string] =
      scala.Option(impl.username()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputSource
  ): zio.aws.medialive.model.InputSource.ReadOnly = new Wrapper(impl)
}
