package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputSourceEndBehavior {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.InputSourceEndBehavior
}
object InputSourceEndBehavior {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputSourceEndBehavior
  ): zio.aws.medialive.model.InputSourceEndBehavior = value match {
    case software.amazon.awssdk.services.medialive.model.InputSourceEndBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputSourceEndBehavior.CONTINUE =>
      val r = CONTINUE
      r
    case software.amazon.awssdk.services.medialive.model.InputSourceEndBehavior.LOOP =>
      val r = LOOP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputSourceEndBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputSourceEndBehavior =
      software.amazon.awssdk.services.medialive.model.InputSourceEndBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object CONTINUE extends zio.aws.medialive.model.InputSourceEndBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputSourceEndBehavior =
      software.amazon.awssdk.services.medialive.model.InputSourceEndBehavior.CONTINUE
  }
  case object LOOP extends zio.aws.medialive.model.InputSourceEndBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputSourceEndBehavior =
      software.amazon.awssdk.services.medialive.model.InputSourceEndBehavior.LOOP
  }
}
