package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputSourceType {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputSourceType
}
object InputSourceType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputSourceType
  ): zio.aws.medialive.model.InputSourceType = value match {
    case software.amazon.awssdk.services.medialive.model.InputSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputSourceType.STATIC =>
      val r = STATIC
      r
    case software.amazon.awssdk.services.medialive.model.InputSourceType.DYNAMIC =>
      val r = DYNAMIC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputSourceType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputSourceType =
      software.amazon.awssdk.services.medialive.model.InputSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object STATIC extends zio.aws.medialive.model.InputSourceType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputSourceType =
      software.amazon.awssdk.services.medialive.model.InputSourceType.STATIC
  }
  case object DYNAMIC extends zio.aws.medialive.model.InputSourceType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputSourceType =
      software.amazon.awssdk.services.medialive.model.InputSourceType.DYNAMIC
  }
}
