package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InputSpecification(
    codec: Option[zio.aws.medialive.model.InputCodec] = None,
    maximumBitrate: Option[zio.aws.medialive.model.InputMaximumBitrate] = None,
    resolution: Option[zio.aws.medialive.model.InputResolution] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputSpecification = {
    import InputSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputSpecification
      .builder()
      .optionallyWith(codec.map(value => value.unwrap))(_.codec)
      .optionallyWith(maximumBitrate.map(value => value.unwrap))(
        _.maximumBitrate
      )
      .optionallyWith(resolution.map(value => value.unwrap))(_.resolution)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputSpecification.ReadOnly =
    zio.aws.medialive.model.InputSpecification.wrap(buildAwsValue())
}
object InputSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputSpecification =
      zio.aws.medialive.model.InputSpecification(
        codec.map(value => value),
        maximumBitrate.map(value => value),
        resolution.map(value => value)
      )
    def codec: Option[zio.aws.medialive.model.InputCodec]
    def maximumBitrate: Option[zio.aws.medialive.model.InputMaximumBitrate]
    def resolution: Option[zio.aws.medialive.model.InputResolution]
    def getCodec: ZIO[Any, AwsError, zio.aws.medialive.model.InputCodec] =
      AwsError.unwrapOptionField("codec", codec)
    def getMaximumBitrate
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputMaximumBitrate] =
      AwsError.unwrapOptionField("maximumBitrate", maximumBitrate)
    def getResolution
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputResolution] =
      AwsError.unwrapOptionField("resolution", resolution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputSpecification
  ) extends zio.aws.medialive.model.InputSpecification.ReadOnly {
    override val codec: Option[zio.aws.medialive.model.InputCodec] = scala
      .Option(impl.codec())
      .map(value => zio.aws.medialive.model.InputCodec.wrap(value))
    override val maximumBitrate
        : Option[zio.aws.medialive.model.InputMaximumBitrate] = scala
      .Option(impl.maximumBitrate())
      .map(value => zio.aws.medialive.model.InputMaximumBitrate.wrap(value))
    override val resolution: Option[zio.aws.medialive.model.InputResolution] =
      scala
        .Option(impl.resolution())
        .map(value => zio.aws.medialive.model.InputResolution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputSpecification
  ): zio.aws.medialive.model.InputSpecification.ReadOnly = new Wrapper(impl)
}
