package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputState {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputState
}
object InputState {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputState
  ): zio.aws.medialive.model.InputState = value match {
    case software.amazon.awssdk.services.medialive.model.InputState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.medialive.model.InputState.DETACHED =>
      val r = DETACHED
      r
    case software.amazon.awssdk.services.medialive.model.InputState.ATTACHED =>
      val r = ATTACHED
      r
    case software.amazon.awssdk.services.medialive.model.InputState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.medialive.model.InputState.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.InputState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputState =
      software.amazon.awssdk.services.medialive.model.InputState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.medialive.model.InputState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputState =
      software.amazon.awssdk.services.medialive.model.InputState.CREATING
  }
  case object DETACHED extends zio.aws.medialive.model.InputState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputState =
      software.amazon.awssdk.services.medialive.model.InputState.DETACHED
  }
  case object ATTACHED extends zio.aws.medialive.model.InputState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputState =
      software.amazon.awssdk.services.medialive.model.InputState.ATTACHED
  }
  case object DELETING extends zio.aws.medialive.model.InputState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputState =
      software.amazon.awssdk.services.medialive.model.InputState.DELETING
  }
  case object DELETED extends zio.aws.medialive.model.InputState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputState =
      software.amazon.awssdk.services.medialive.model.InputState.DELETED
  }
}
