package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class InputSwitchScheduleActionSettings(
    inputAttachmentNameReference: __string,
    inputClippingSettings: Option[
      zio.aws.medialive.model.InputClippingSettings
    ] = None,
    urlPath: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputSwitchScheduleActionSettings = {
    import InputSwitchScheduleActionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputSwitchScheduleActionSettings
      .builder()
      .inputAttachmentNameReference(
        inputAttachmentNameReference: java.lang.String
      )
      .optionallyWith(
        inputClippingSettings.map(value => value.buildAwsValue())
      )(_.inputClippingSettings)
      .optionallyWith(
        urlPath.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.urlPath)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.InputSwitchScheduleActionSettings.ReadOnly =
    zio.aws.medialive.model.InputSwitchScheduleActionSettings
      .wrap(buildAwsValue())
}
object InputSwitchScheduleActionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputSwitchScheduleActionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputSwitchScheduleActionSettings =
      zio.aws.medialive.model.InputSwitchScheduleActionSettings(
        inputAttachmentNameReference,
        inputClippingSettings.map(value => value.asEditable),
        urlPath.map(value => value)
      )
    def inputAttachmentNameReference: __string
    def inputClippingSettings
        : Option[zio.aws.medialive.model.InputClippingSettings.ReadOnly]
    def urlPath: Option[List[__string]]
    def getInputAttachmentNameReference: ZIO[Any, Nothing, __string] =
      ZIO.succeed(inputAttachmentNameReference)
    def getInputClippingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputClippingSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("inputClippingSettings", inputClippingSettings)
    def getUrlPath: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("urlPath", urlPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputSwitchScheduleActionSettings
  ) extends zio.aws.medialive.model.InputSwitchScheduleActionSettings.ReadOnly {
    override val inputAttachmentNameReference: __string =
      impl.inputAttachmentNameReference(): __string
    override val inputClippingSettings
        : Option[zio.aws.medialive.model.InputClippingSettings.ReadOnly] = scala
      .Option(impl.inputClippingSettings())
      .map(value => zio.aws.medialive.model.InputClippingSettings.wrap(value))
    override val urlPath: Option[List[__string]] = scala
      .Option(impl.urlPath())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputSwitchScheduleActionSettings
  ): zio.aws.medialive.model.InputSwitchScheduleActionSettings.ReadOnly =
    new Wrapper(impl)
}
