package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputTimecodeSource {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.InputTimecodeSource
}
object InputTimecodeSource {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputTimecodeSource
  ): zio.aws.medialive.model.InputTimecodeSource = value match {
    case software.amazon.awssdk.services.medialive.model.InputTimecodeSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputTimecodeSource.ZEROBASED =>
      val r = ZEROBASED
      r
    case software.amazon.awssdk.services.medialive.model.InputTimecodeSource.EMBEDDED =>
      val r = EMBEDDED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.InputTimecodeSource {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputTimecodeSource =
      software.amazon.awssdk.services.medialive.model.InputTimecodeSource.UNKNOWN_TO_SDK_VERSION
  }
  case object ZEROBASED extends zio.aws.medialive.model.InputTimecodeSource {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputTimecodeSource =
      software.amazon.awssdk.services.medialive.model.InputTimecodeSource.ZEROBASED
  }
  case object EMBEDDED extends zio.aws.medialive.model.InputTimecodeSource {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputTimecodeSource =
      software.amazon.awssdk.services.medialive.model.InputTimecodeSource.EMBEDDED
  }
}
