package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait InputType {
  def unwrap: software.amazon.awssdk.services.medialive.model.InputType
}
object InputType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.InputType
  ): zio.aws.medialive.model.InputType = value match {
    case software.amazon.awssdk.services.medialive.model.InputType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.InputType.UDP_PUSH =>
      val r = UDP_PUSH
      r
    case software.amazon.awssdk.services.medialive.model.InputType.RTP_PUSH =>
      val r = RTP_PUSH
      r
    case software.amazon.awssdk.services.medialive.model.InputType.RTMP_PUSH =>
      val r = RTMP_PUSH
      r
    case software.amazon.awssdk.services.medialive.model.InputType.RTMP_PULL =>
      val r = RTMP_PULL
      r
    case software.amazon.awssdk.services.medialive.model.InputType.URL_PULL =>
      val r = URL_PULL
      r
    case software.amazon.awssdk.services.medialive.model.InputType.MP4_FILE =>
      val r = MP4_FILE
      r
    case software.amazon.awssdk.services.medialive.model.InputType.MEDIACONNECT =>
      val r = MEDIACONNECT
      r
    case software.amazon.awssdk.services.medialive.model.InputType.INPUT_DEVICE =>
      val r = INPUT_DEVICE
      r
    case software.amazon.awssdk.services.medialive.model.InputType.AWS_CDI =>
      val r = AWS_CDI
      r
    case software.amazon.awssdk.services.medialive.model.InputType.TS_FILE =>
      val r = TS_FILE
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputType =
      software.amazon.awssdk.services.medialive.model.InputType.UNKNOWN_TO_SDK_VERSION
  }
  case object UDP_PUSH extends zio.aws.medialive.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputType =
      software.amazon.awssdk.services.medialive.model.InputType.UDP_PUSH
  }
  case object RTP_PUSH extends zio.aws.medialive.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputType =
      software.amazon.awssdk.services.medialive.model.InputType.RTP_PUSH
  }
  case object RTMP_PUSH extends zio.aws.medialive.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputType =
      software.amazon.awssdk.services.medialive.model.InputType.RTMP_PUSH
  }
  case object RTMP_PULL extends zio.aws.medialive.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputType =
      software.amazon.awssdk.services.medialive.model.InputType.RTMP_PULL
  }
  case object URL_PULL extends zio.aws.medialive.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputType =
      software.amazon.awssdk.services.medialive.model.InputType.URL_PULL
  }
  case object MP4_FILE extends zio.aws.medialive.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputType =
      software.amazon.awssdk.services.medialive.model.InputType.MP4_FILE
  }
  case object MEDIACONNECT extends zio.aws.medialive.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputType =
      software.amazon.awssdk.services.medialive.model.InputType.MEDIACONNECT
  }
  case object INPUT_DEVICE extends zio.aws.medialive.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputType =
      software.amazon.awssdk.services.medialive.model.InputType.INPUT_DEVICE
  }
  case object AWS_CDI extends zio.aws.medialive.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputType =
      software.amazon.awssdk.services.medialive.model.InputType.AWS_CDI
  }
  case object TS_FILE extends zio.aws.medialive.model.InputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.InputType =
      software.amazon.awssdk.services.medialive.model.InputType.TS_FILE
  }
}
