package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class InputVpcRequest(
    securityGroupIds: Option[Iterable[__string]] = None,
    subnetIds: Iterable[__string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputVpcRequest = {
    import InputVpcRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputVpcRequest
      .builder()
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputVpcRequest.ReadOnly =
    zio.aws.medialive.model.InputVpcRequest.wrap(buildAwsValue())
}
object InputVpcRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputVpcRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputVpcRequest =
      zio.aws.medialive.model
        .InputVpcRequest(securityGroupIds.map(value => value), subnetIds)
    def securityGroupIds: Option[List[__string]]
    def subnetIds: List[__string]
    def getSecurityGroupIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputVpcRequest
  ) extends zio.aws.medialive.model.InputVpcRequest.ReadOnly {
    override val securityGroupIds: Option[List[__string]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val subnetIds: List[__string] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputVpcRequest
  ): zio.aws.medialive.model.InputVpcRequest.ReadOnly = new Wrapper(impl)
}
