package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class InputWhitelistRule(cidr: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.InputWhitelistRule = {
    import InputWhitelistRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.InputWhitelistRule
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.InputWhitelistRule.ReadOnly =
    zio.aws.medialive.model.InputWhitelistRule.wrap(buildAwsValue())
}
object InputWhitelistRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.InputWhitelistRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.InputWhitelistRule =
      zio.aws.medialive.model.InputWhitelistRule(cidr.map(value => value))
    def cidr: Option[__string]
    def getCidr: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("cidr", cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.InputWhitelistRule
  ) extends zio.aws.medialive.model.InputWhitelistRule.ReadOnly {
    override val cidr: Option[__string] =
      scala.Option(impl.cidr()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.InputWhitelistRule
  ): zio.aws.medialive.model.InputWhitelistRule.ReadOnly = new Wrapper(impl)
}
