package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KeyProviderSettings(
    staticKeySettings: Option[zio.aws.medialive.model.StaticKeySettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.KeyProviderSettings = {
    import KeyProviderSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.KeyProviderSettings
      .builder()
      .optionallyWith(staticKeySettings.map(value => value.buildAwsValue()))(
        _.staticKeySettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.KeyProviderSettings.ReadOnly =
    zio.aws.medialive.model.KeyProviderSettings.wrap(buildAwsValue())
}
object KeyProviderSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.KeyProviderSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.KeyProviderSettings =
      zio.aws.medialive.model
        .KeyProviderSettings(staticKeySettings.map(value => value.asEditable))
    def staticKeySettings
        : Option[zio.aws.medialive.model.StaticKeySettings.ReadOnly]
    def getStaticKeySettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.StaticKeySettings.ReadOnly
    ] = AwsError.unwrapOptionField("staticKeySettings", staticKeySettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.KeyProviderSettings
  ) extends zio.aws.medialive.model.KeyProviderSettings.ReadOnly {
    override val staticKeySettings
        : Option[zio.aws.medialive.model.StaticKeySettings.ReadOnly] = scala
      .Option(impl.staticKeySettings())
      .map(value => zio.aws.medialive.model.StaticKeySettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.KeyProviderSettings
  ): zio.aws.medialive.model.KeyProviderSettings.ReadOnly = new Wrapper(impl)
}
