package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListChannelsResponse(
    channels: Option[Iterable[zio.aws.medialive.model.ChannelSummary]] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListChannelsResponse = {
    import ListChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListChannelsResponse
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channels)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ListChannelsResponse.ReadOnly =
    zio.aws.medialive.model.ListChannelsResponse.wrap(buildAwsValue())
}
object ListChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListChannelsResponse =
      zio.aws.medialive.model.ListChannelsResponse(
        channels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def channels: Option[List[zio.aws.medialive.model.ChannelSummary.ReadOnly]]
    def nextToken: Option[__string]
    def getChannels: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.ChannelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("channels", channels)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListChannelsResponse
  ) extends zio.aws.medialive.model.ListChannelsResponse.ReadOnly {
    override val channels
        : Option[List[zio.aws.medialive.model.ChannelSummary.ReadOnly]] = scala
      .Option(impl.channels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.ChannelSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListChannelsResponse
  ): zio.aws.medialive.model.ListChannelsResponse.ReadOnly = new Wrapper(impl)
}
