package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__string, MaxResults}
import scala.jdk.CollectionConverters._
final case class ListInputDeviceTransfersRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None,
    transferType: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest = {
    import ListInputDeviceTransfersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .transferType(transferType: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.ListInputDeviceTransfersRequest.ReadOnly =
    zio.aws.medialive.model.ListInputDeviceTransfersRequest
      .wrap(buildAwsValue())
}
object ListInputDeviceTransfersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListInputDeviceTransfersRequest =
      zio.aws.medialive.model.ListInputDeviceTransfersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        transferType
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def transferType: __string
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTransferType: ZIO[Any, Nothing, __string] = ZIO.succeed(transferType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest
  ) extends zio.aws.medialive.model.ListInputDeviceTransfersRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.medialive.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val transferType: __string = impl.transferType(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest
  ): zio.aws.medialive.model.ListInputDeviceTransfersRequest.ReadOnly =
    new Wrapper(impl)
}
