package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListInputDeviceTransfersResponse(
    inputDeviceTransfers: Option[
      Iterable[zio.aws.medialive.model.TransferringInputDeviceSummary]
    ] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse = {
    import ListInputDeviceTransfersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse
      .builder()
      .optionallyWith(
        inputDeviceTransfers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDeviceTransfers)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.ListInputDeviceTransfersResponse.ReadOnly =
    zio.aws.medialive.model.ListInputDeviceTransfersResponse
      .wrap(buildAwsValue())
}
object ListInputDeviceTransfersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListInputDeviceTransfersResponse =
      zio.aws.medialive.model.ListInputDeviceTransfersResponse(
        inputDeviceTransfers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def inputDeviceTransfers: Option[
      List[zio.aws.medialive.model.TransferringInputDeviceSummary.ReadOnly]
    ]
    def nextToken: Option[__string]
    def getInputDeviceTransfers: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.TransferringInputDeviceSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("inputDeviceTransfers", inputDeviceTransfers)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse
  ) extends zio.aws.medialive.model.ListInputDeviceTransfersResponse.ReadOnly {
    override val inputDeviceTransfers: Option[
      List[zio.aws.medialive.model.TransferringInputDeviceSummary.ReadOnly]
    ] = scala
      .Option(impl.inputDeviceTransfers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.TransferringInputDeviceSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse
  ): zio.aws.medialive.model.ListInputDeviceTransfersResponse.ReadOnly =
    new Wrapper(impl)
}
