package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListInputDevicesResponse(
    inputDevices: Option[Iterable[zio.aws.medialive.model.InputDeviceSummary]] =
      None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse = {
    import ListInputDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse
      .builder()
      .optionallyWith(
        inputDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDevices)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ListInputDevicesResponse.ReadOnly =
    zio.aws.medialive.model.ListInputDevicesResponse.wrap(buildAwsValue())
}
object ListInputDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListInputDevicesResponse =
      zio.aws.medialive.model.ListInputDevicesResponse(
        inputDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def inputDevices
        : Option[List[zio.aws.medialive.model.InputDeviceSummary.ReadOnly]]
    def nextToken: Option[__string]
    def getInputDevices: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputDeviceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("inputDevices", inputDevices)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse
  ) extends zio.aws.medialive.model.ListInputDevicesResponse.ReadOnly {
    override val inputDevices
        : Option[List[zio.aws.medialive.model.InputDeviceSummary.ReadOnly]] =
      scala
        .Option(impl.inputDevices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.InputDeviceSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse
  ): zio.aws.medialive.model.ListInputDevicesResponse.ReadOnly = new Wrapper(
    impl
  )
}
