package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__string, MaxResults}
import scala.jdk.CollectionConverters._
final case class ListInputSecurityGroupsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest = {
    import ListInputSecurityGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.ListInputSecurityGroupsRequest.ReadOnly =
    zio.aws.medialive.model.ListInputSecurityGroupsRequest.wrap(buildAwsValue())
}
object ListInputSecurityGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListInputSecurityGroupsRequest =
      zio.aws.medialive.model.ListInputSecurityGroupsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest
  ) extends zio.aws.medialive.model.ListInputSecurityGroupsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.medialive.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest
  ): zio.aws.medialive.model.ListInputSecurityGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
