package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListInputSecurityGroupsResponse(
    inputSecurityGroups: Option[
      Iterable[zio.aws.medialive.model.InputSecurityGroup]
    ] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse = {
    import ListInputSecurityGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse
      .builder()
      .optionallyWith(
        inputSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputSecurityGroups)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.ListInputSecurityGroupsResponse.ReadOnly =
    zio.aws.medialive.model.ListInputSecurityGroupsResponse
      .wrap(buildAwsValue())
}
object ListInputSecurityGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListInputSecurityGroupsResponse =
      zio.aws.medialive.model.ListInputSecurityGroupsResponse(
        inputSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def inputSecurityGroups
        : Option[List[zio.aws.medialive.model.InputSecurityGroup.ReadOnly]]
    def nextToken: Option[__string]
    def getInputSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.InputSecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("inputSecurityGroups", inputSecurityGroups)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse
  ) extends zio.aws.medialive.model.ListInputSecurityGroupsResponse.ReadOnly {
    override val inputSecurityGroups
        : Option[List[zio.aws.medialive.model.InputSecurityGroup.ReadOnly]] =
      scala
        .Option(impl.inputSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.InputSecurityGroup.wrap(item)
          }.toList
        )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse
  ): zio.aws.medialive.model.ListInputSecurityGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
