package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__string, MaxResults}
import scala.jdk.CollectionConverters._
final case class ListInputsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListInputsRequest = {
    import ListInputsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListInputsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ListInputsRequest.ReadOnly =
    zio.aws.medialive.model.ListInputsRequest.wrap(buildAwsValue())
}
object ListInputsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListInputsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListInputsRequest =
      zio.aws.medialive.model.ListInputsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListInputsRequest
  ) extends zio.aws.medialive.model.ListInputsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.medialive.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListInputsRequest
  ): zio.aws.medialive.model.ListInputsRequest.ReadOnly = new Wrapper(impl)
}
