package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListInputsResponse(
    inputs: Option[Iterable[zio.aws.medialive.model.Input]] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListInputsResponse = {
    import ListInputsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListInputsResponse
      .builder()
      .optionallyWith(
        inputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ListInputsResponse.ReadOnly =
    zio.aws.medialive.model.ListInputsResponse.wrap(buildAwsValue())
}
object ListInputsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListInputsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListInputsResponse =
      zio.aws.medialive.model.ListInputsResponse(
        inputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def inputs: Option[List[zio.aws.medialive.model.Input.ReadOnly]]
    def nextToken: Option[__string]
    def getInputs
        : ZIO[Any, AwsError, List[zio.aws.medialive.model.Input.ReadOnly]] =
      AwsError.unwrapOptionField("inputs", inputs)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListInputsResponse
  ) extends zio.aws.medialive.model.ListInputsResponse.ReadOnly {
    override val inputs: Option[List[zio.aws.medialive.model.Input.ReadOnly]] =
      scala
        .Option(impl.inputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.Input.wrap(item)
          }.toList
        )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListInputsResponse
  ): zio.aws.medialive.model.ListInputsResponse.ReadOnly = new Wrapper(impl)
}
