package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__string, MaxResults}
import scala.jdk.CollectionConverters._
final case class ListMultiplexProgramsRequest(
    maxResults: Option[MaxResults] = None,
    multiplexId: __string,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest = {
    import ListMultiplexProgramsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .multiplexId(multiplexId: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.ListMultiplexProgramsRequest.ReadOnly =
    zio.aws.medialive.model.ListMultiplexProgramsRequest.wrap(buildAwsValue())
}
object ListMultiplexProgramsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListMultiplexProgramsRequest =
      zio.aws.medialive.model.ListMultiplexProgramsRequest(
        maxResults.map(value => value),
        multiplexId,
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def multiplexId: __string
    def nextToken: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getMultiplexId: ZIO[Any, Nothing, __string] = ZIO.succeed(multiplexId)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest
  ) extends zio.aws.medialive.model.ListMultiplexProgramsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.medialive.model.primitives.MaxResults(value))
    override val multiplexId: __string = impl.multiplexId(): __string
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest
  ): zio.aws.medialive.model.ListMultiplexProgramsRequest.ReadOnly =
    new Wrapper(impl)
}
