package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListMultiplexProgramsResponse(
    multiplexPrograms: Option[
      Iterable[zio.aws.medialive.model.MultiplexProgramSummary]
    ] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse = {
    import ListMultiplexProgramsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse
      .builder()
      .optionallyWith(
        multiplexPrograms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.multiplexPrograms)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.ListMultiplexProgramsResponse.ReadOnly =
    zio.aws.medialive.model.ListMultiplexProgramsResponse.wrap(buildAwsValue())
}
object ListMultiplexProgramsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListMultiplexProgramsResponse =
      zio.aws.medialive.model.ListMultiplexProgramsResponse(
        multiplexPrograms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def multiplexPrograms
        : Option[List[zio.aws.medialive.model.MultiplexProgramSummary.ReadOnly]]
    def nextToken: Option[__string]
    def getMultiplexPrograms: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.MultiplexProgramSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("multiplexPrograms", multiplexPrograms)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse
  ) extends zio.aws.medialive.model.ListMultiplexProgramsResponse.ReadOnly {
    override val multiplexPrograms: Option[
      List[zio.aws.medialive.model.MultiplexProgramSummary.ReadOnly]
    ] = scala
      .Option(impl.multiplexPrograms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.MultiplexProgramSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse
  ): zio.aws.medialive.model.ListMultiplexProgramsResponse.ReadOnly =
    new Wrapper(impl)
}
