package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListMultiplexesResponse(
    multiplexes: Option[Iterable[zio.aws.medialive.model.MultiplexSummary]] =
      None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse = {
    import ListMultiplexesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse
      .builder()
      .optionallyWith(
        multiplexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.multiplexes)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ListMultiplexesResponse.ReadOnly =
    zio.aws.medialive.model.ListMultiplexesResponse.wrap(buildAwsValue())
}
object ListMultiplexesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListMultiplexesResponse =
      zio.aws.medialive.model.ListMultiplexesResponse(
        multiplexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def multiplexes
        : Option[List[zio.aws.medialive.model.MultiplexSummary.ReadOnly]]
    def nextToken: Option[__string]
    def getMultiplexes: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.MultiplexSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("multiplexes", multiplexes)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse
  ) extends zio.aws.medialive.model.ListMultiplexesResponse.ReadOnly {
    override val multiplexes
        : Option[List[zio.aws.medialive.model.MultiplexSummary.ReadOnly]] =
      scala
        .Option(impl.multiplexes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.MultiplexSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse
  ): zio.aws.medialive.model.ListMultiplexesResponse.ReadOnly = new Wrapper(
    impl
  )
}
