package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{MaxResults, __string}
import scala.jdk.CollectionConverters._
final case class ListOfferingsRequest(
    channelClass: Option[__string] = None,
    channelConfiguration: Option[__string] = None,
    codec: Option[__string] = None,
    duration: Option[__string] = None,
    maxResults: Option[MaxResults] = None,
    maximumBitrate: Option[__string] = None,
    maximumFramerate: Option[__string] = None,
    nextToken: Option[__string] = None,
    resolution: Option[__string] = None,
    resourceType: Option[__string] = None,
    specialFeature: Option[__string] = None,
    videoQuality: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListOfferingsRequest = {
    import ListOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListOfferingsRequest
      .builder()
      .optionallyWith(channelClass.map(value => value: java.lang.String))(
        _.channelClass
      )
      .optionallyWith(
        channelConfiguration.map(value => value: java.lang.String)
      )(_.channelConfiguration)
      .optionallyWith(codec.map(value => value: java.lang.String))(_.codec)
      .optionallyWith(duration.map(value => value: java.lang.String))(
        _.duration
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(maximumBitrate.map(value => value: java.lang.String))(
        _.maximumBitrate
      )
      .optionallyWith(maximumFramerate.map(value => value: java.lang.String))(
        _.maximumFramerate
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(resolution.map(value => value: java.lang.String))(
        _.resolution
      )
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(specialFeature.map(value => value: java.lang.String))(
        _.specialFeature
      )
      .optionallyWith(videoQuality.map(value => value: java.lang.String))(
        _.videoQuality
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ListOfferingsRequest.ReadOnly =
    zio.aws.medialive.model.ListOfferingsRequest.wrap(buildAwsValue())
}
object ListOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListOfferingsRequest =
      zio.aws.medialive.model.ListOfferingsRequest(
        channelClass.map(value => value),
        channelConfiguration.map(value => value),
        codec.map(value => value),
        duration.map(value => value),
        maxResults.map(value => value),
        maximumBitrate.map(value => value),
        maximumFramerate.map(value => value),
        nextToken.map(value => value),
        resolution.map(value => value),
        resourceType.map(value => value),
        specialFeature.map(value => value),
        videoQuality.map(value => value)
      )
    def channelClass: Option[__string]
    def channelConfiguration: Option[__string]
    def codec: Option[__string]
    def duration: Option[__string]
    def maxResults: Option[MaxResults]
    def maximumBitrate: Option[__string]
    def maximumFramerate: Option[__string]
    def nextToken: Option[__string]
    def resolution: Option[__string]
    def resourceType: Option[__string]
    def specialFeature: Option[__string]
    def videoQuality: Option[__string]
    def getChannelClass: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelClass", channelClass)
    def getChannelConfiguration: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelConfiguration", channelConfiguration)
    def getCodec: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("codec", codec)
    def getDuration: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("duration", duration)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getMaximumBitrate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("maximumBitrate", maximumBitrate)
    def getMaximumFramerate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("maximumFramerate", maximumFramerate)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResolution: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("resolution", resolution)
    def getResourceType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSpecialFeature: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("specialFeature", specialFeature)
    def getVideoQuality: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("videoQuality", videoQuality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListOfferingsRequest
  ) extends zio.aws.medialive.model.ListOfferingsRequest.ReadOnly {
    override val channelClass: Option[__string] =
      scala.Option(impl.channelClass()).map(value => value: __string)
    override val channelConfiguration: Option[__string] =
      scala.Option(impl.channelConfiguration()).map(value => value: __string)
    override val codec: Option[__string] =
      scala.Option(impl.codec()).map(value => value: __string)
    override val duration: Option[__string] =
      scala.Option(impl.duration()).map(value => value: __string)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.medialive.model.primitives.MaxResults(value))
    override val maximumBitrate: Option[__string] =
      scala.Option(impl.maximumBitrate()).map(value => value: __string)
    override val maximumFramerate: Option[__string] =
      scala.Option(impl.maximumFramerate()).map(value => value: __string)
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val resolution: Option[__string] =
      scala.Option(impl.resolution()).map(value => value: __string)
    override val resourceType: Option[__string] =
      scala.Option(impl.resourceType()).map(value => value: __string)
    override val specialFeature: Option[__string] =
      scala.Option(impl.specialFeature()).map(value => value: __string)
    override val videoQuality: Option[__string] =
      scala.Option(impl.videoQuality()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListOfferingsRequest
  ): zio.aws.medialive.model.ListOfferingsRequest.ReadOnly = new Wrapper(impl)
}
