package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListOfferingsResponse(
    nextToken: Option[__string] = None,
    offerings: Option[Iterable[zio.aws.medialive.model.Offering]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListOfferingsResponse = {
    import ListOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListOfferingsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        offerings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.offerings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ListOfferingsResponse.ReadOnly =
    zio.aws.medialive.model.ListOfferingsResponse.wrap(buildAwsValue())
}
object ListOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListOfferingsResponse =
      zio.aws.medialive.model.ListOfferingsResponse(
        nextToken.map(value => value),
        offerings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[__string]
    def offerings: Option[List[zio.aws.medialive.model.Offering.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOfferings
        : ZIO[Any, AwsError, List[zio.aws.medialive.model.Offering.ReadOnly]] =
      AwsError.unwrapOptionField("offerings", offerings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListOfferingsResponse
  ) extends zio.aws.medialive.model.ListOfferingsResponse.ReadOnly {
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val offerings
        : Option[List[zio.aws.medialive.model.Offering.ReadOnly]] = scala
      .Option(impl.offerings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.Offering.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListOfferingsResponse
  ): zio.aws.medialive.model.ListOfferingsResponse.ReadOnly = new Wrapper(impl)
}
