package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ListReservationsResponse(
    nextToken: Option[__string] = None,
    reservations: Option[Iterable[zio.aws.medialive.model.Reservation]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ListReservationsResponse = {
    import ListReservationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ListReservationsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        reservations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservations)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ListReservationsResponse.ReadOnly =
    zio.aws.medialive.model.ListReservationsResponse.wrap(buildAwsValue())
}
object ListReservationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ListReservationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ListReservationsResponse =
      zio.aws.medialive.model.ListReservationsResponse(
        nextToken.map(value => value),
        reservations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[__string]
    def reservations: Option[List[zio.aws.medialive.model.Reservation.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReservations: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.Reservation.ReadOnly
    ]] = AwsError.unwrapOptionField("reservations", reservations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ListReservationsResponse
  ) extends zio.aws.medialive.model.ListReservationsResponse.ReadOnly {
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val reservations
        : Option[List[zio.aws.medialive.model.Reservation.ReadOnly]] = scala
      .Option(impl.reservations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.Reservation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ListReservationsResponse
  ): zio.aws.medialive.model.ListReservationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
