package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait LogLevel {
  def unwrap: software.amazon.awssdk.services.medialive.model.LogLevel
}
object LogLevel {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.LogLevel
  ): zio.aws.medialive.model.LogLevel = value match {
    case software.amazon.awssdk.services.medialive.model.LogLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.LogLevel.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.medialive.model.LogLevel.WARNING =>
      val r = WARNING
      r
    case software.amazon.awssdk.services.medialive.model.LogLevel.INFO =>
      val r = INFO
      r
    case software.amazon.awssdk.services.medialive.model.LogLevel.DEBUG =>
      val r = DEBUG
      r
    case software.amazon.awssdk.services.medialive.model.LogLevel.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.LogLevel =
      software.amazon.awssdk.services.medialive.model.LogLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object ERROR extends zio.aws.medialive.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.LogLevel =
      software.amazon.awssdk.services.medialive.model.LogLevel.ERROR
  }
  case object WARNING extends zio.aws.medialive.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.LogLevel =
      software.amazon.awssdk.services.medialive.model.LogLevel.WARNING
  }
  case object INFO extends zio.aws.medialive.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.LogLevel =
      software.amazon.awssdk.services.medialive.model.LogLevel.INFO
  }
  case object DEBUG extends zio.aws.medialive.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.LogLevel =
      software.amazon.awssdk.services.medialive.model.LogLevel.DEBUG
  }
  case object DISABLED extends zio.aws.medialive.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.LogLevel =
      software.amazon.awssdk.services.medialive.model.LogLevel.DISABLED
  }
}
